<?php require_once("../config/db.php"); ?>
<?php include('../actions/auto_update_status.php'); ?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title >VC Engagement Dashboard</title>
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.15/index.global.min.js"></script>
</head>
<body class="bg-gray-100 min-h-screen">

<!-- ====== HEADER / NAVBAR ====== -->
<header class="bg-blue-800 text-white shadow-md sticky top-0 z-50 flex items-center justify-between px-6 py-3">
  <div class="flex items-center gap-3">
    <img src="../assets/images/mnsuam_logo.png" alt="MNSUAM Logo" class="h-12">
    <div>
      <h1 class="text-xl font-semibold leading-tight">VC Engagement Dashboard</h1>
      <p class="text-sm text-blue-200">MNS University of Agriculture, Multan</p>
    </div>
  </div>
  <div class="text-right">
    <p class="text-base font-medium">Vice Chancellor</p>
    <p class="text-sm text-blue-200">Professor Dr. Asif Ali (T.I)</p>
  </div>
</header>


<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 p-6">
  <div class="bg-white p-5 rounded-xl shadow-md text-center">
    <h2 class="text-gray-500 text-sm">Total Meetings</h2>
    <p id="totalMeetings" class="text-3xl font-bold text-blue-700">0</p>
  </div>
  <div class="bg-white p-5 rounded-xl shadow-md text-center">
    <h2 class="text-gray-500 text-sm">Upcoming Meetings</h2>
    <p id="upcomingMeetings" class="text-3xl font-bold text-green-600">0</p>
  </div>
  <div class="bg-white p-5 rounded-xl shadow-md text-center">
    <h2 class="text-gray-500 text-sm">Completed Meetings</h2>
    <p id="completedMeetings" class="text-3xl font-bold text-purple-600">0</p>
  </div>
  <div class="bg-white p-5 rounded-xl shadow-md text-center">
    <h2 class="text-gray-500 text-sm">This Month</h2>
    <p id="monthMeetings" class="text-3xl font-bold text-orange-500">0</p>
  </div>
</div>

<div class="flex justify-center gap-4 mb-5">
  <button class="tab-btn active bg-blue-700 text-white px-4 py-2 rounded-lg" data-tab="calendar">📅 Calendar</button>
  <button class="tab-btn bg-gray-300 text-gray-700 px-4 py-2 rounded-lg" data-tab="table">📋 Table</button>
  <button class="tab-btn bg-gray-300 text-gray-700 px-4 py-2 rounded-lg" data-tab="history">📜 History</button>

  <button class="tab-btn bg-gray-300 text-gray-700 px-4 py-2 rounded-lg" data-tab="add">➕ Add Meeting</button>
</div>

<div class="max-w-6xl mx-auto bg-white rounded-xl shadow-md p-6">
  <div id="calendar-tab" class="tab-content">
    <div id="calendar"></div>
  </div>
<!-- TABLE VIEW -->


<div id="table-tab" class="tab-content hidden">
<div class="flex justify-end mb-3">
  <button id="printPDF" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
    🖨️ Export to PDF
  </button>
</div>
  <table class="min-w-full border mt-4">
    <thead>
      <tr class="bg-blue-100 text-gray-700">
        <th class="border px-3 py-2">Date</th>
        <th class="border px-3 py-2">Day</th>			
        <th class="border px-3 py-2">Title</th>
        <th class="border px-3 py-2">Time</th>
        <th class="border px-3 py-2">Venue</th>
        <th class="border px-3 py-2">Organized By</th>
        <th class="border px-3 py-2">Contact</th>
        <th class="border px-3 py-2">Meeting Type</th>
        <th class="border px-3 py-2">Status</th>
        <th class="border px-3 py-2">Discription</th>
		
        <th class="border px-3 py-2">Actions</th>
      </tr>
    </thead>
    <tbody id="meetingsTable"></tbody>
  </table>
</div>
<!-- HISTORY VIEW -->
<div id="history-tab" class="tab-content hidden">
  <table class="min-w-full border mt-4">
    <thead>
      <tr class="bg-purple-100 text-gray-700">
        <th class="border px-3 py-2">Title</th>
        <th class="border px-3 py-2">Date</th>
        <th class="border px-3 py-2">Time</th>
        <th class="border px-3 py-2">Venue</th>
        <th class="border px-3 py-2">Organized By</th>
        <th class="border px-3 py-2">Contact</th>
        <th class="border px-3 py-2">Type</th>
        <th class="border px-3 py-2">Status</th>
      </tr>
    </thead>
    <tbody id="historyTable"></tbody>
  </table>
</div>

  <div id="add-tab" class="tab-content hidden">
<form id="addMeetingForm" class="space-y-3 mt-4">
    <input type="text" name="title" placeholder="Meeting Title" class="w-full border rounded p-2" required>
    <input type="date" name="meeting_date" class="w-full border rounded p-2" required>
    <input type="time" name="meeting_time" class="w-full border rounded p-2">
    <input type="text" name="venue" placeholder="Venue (optional)" class="w-full border rounded p-2">
    <input type="text" name="organized_by" placeholder="Organized By (optional)" class="w-full border rounded p-2">
    <input type="text" name="contact_info" placeholder="Contact Info (optional)" class="w-full border rounded p-2">
    <textarea name="description" placeholder="Description (optional)" class="w-full border rounded p-2"></textarea>
    
    <select name="meeting_type" class="w-full border rounded p-2">
        <option value="Physical" selected>Physical</option>
        <option value="Online">Online</option>
    </select>
    
    <button type="submit" class="bg-blue-700 text-white px-5 py-2 rounded-lg hover:bg-blue-800">Save Meeting</button>
</form>


  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {

  let meetingsData = []; // store fetched data for edit buttons
  let calendar = null;

  // ---------- TAB SWITCHING ----------
  const tabs = document.querySelectorAll('.tab-btn');
  const tabContents = document.querySelectorAll('.tab-content');

  tabs.forEach(tab => {
    tab.addEventListener('click', () => {
      const target = tab.dataset.tab;
      tabContents.forEach(c => c.classList.add('hidden'));
      document.getElementById(target + '-tab').classList.remove('hidden');
      tabs.forEach(btn => btn.classList.remove('bg-blue-700','text-white'));
      tabs.forEach(btn => btn.classList.add('bg-gray-300','text-gray-700'));
      tab.classList.remove('bg-gray-300','text-gray-700');
      tab.classList.add('bg-blue-700','text-white');

      if(target === 'calendar') loadCalendar();
      if(target === 'table') loadTable();
	  if(target === 'history') loadHistory();

    });
  });

  // ---------- FETCH & RENDER CALENDAR ----------
  function loadCalendar() {
    fetch('../actions/fetch_meetings.php')
      .then(res => res.json())
      .then(data => {
        meetingsData = data;
        const calendarEl = document.getElementById('calendar');

        // Destroy previous calendar if exists
        if(calendar) calendar.destroy();

        calendar = new FullCalendar.Calendar(calendarEl, {
          initialView: 'dayGridMonth',
          height: 650,
          events: data.map(e => ({
            id: e.id,
            title: e.title,
            start: e.start,
            description: e.description
          })),
          eventClick: info => {
            const meeting = meetingsData.find(m => m.id == info.event.id);
            if(meeting){
              if(confirm('Do you want to edit this meeting?')){
                openEditForm(meeting);
              } else {
                alert(`${info.event.title}\n${new Date(info.event.start).toLocaleString()}\n${info.event.extendedProps.description || ''}`);
              }
            }
          }
        });
        calendar.render();
      })
      .catch(err => console.error('Error loading calendar:', err));
  }

  // ---------- FETCH & RENDER TABLE ----------
function loadTable() {
  fetch('../actions/fetch_meetings.php')
    .then(res => res.json())
    .then(data => {
      meetingsData = data;
      const tbody = document.getElementById('meetingsTable');
      tbody.innerHTML = '';

      const today = new Date().toISOString().split('T')[0];
      const upcoming = data.filter(m => m.meeting_date >= today);

      upcoming.forEach(row => {
        const dateObj = new Date(row.meeting_date);
        const dayName = dateObj.toLocaleDateString('en-US', { weekday: 'long' }); // Mon, Tue, etc.
        const formattedDate = dateObj.toLocaleDateString('en-GB', {
          day: '2-digit',
          month: 'short',
          year: 'numeric'
        }).replace(/ /g, '-'); // e.g., 21-Oct-2025

        const tr = document.createElement('tr');
        tr.innerHTML = `
          
          <td class="border px-3 py-2 w-56">${formattedDate}</td>
		  <td class="border px-3 py-2">${dayName}</td>
		  <td class="border px-3 py-2 w-56">${row.title}</td>
          <td class="border px-3 py-2">${row.meeting_time}</td>
          <td class="border px-3 py-2">${row.venue}</td>
          <td class="border px-3 py-2">${row.organized_by}</td>
          <td class="border px-3 py-2">${row.contact_info}</td>
          <td class="border px-3 py-2">${row.meeting_type}</td>
          <td class="border px-3 py-2">${row.status}</td>
          <td class="border px-3 py-2">${row.description}</td>
          <td class="border px-3 py-2">
            <button class="edit-btn bg-yellow-400 text-white px-2 py-1 rounded mr-2" data-id="${row.id}">Edit</button>
            <button class="delete-btn bg-red-500 text-white px-2 py-1 rounded" data-id="${row.id}">Delete</button>
          </td>
        `;
        tbody.appendChild(tr);
      });
    })
    .catch(err => console.error('Error loading table:', err));
}


// ---------- FETCH & RENDER HISTORY ----------
function loadHistory() {
  fetch('../actions/fetch_meetings.php')
    .then(res => res.json())
    .then(data => {
      const tbody = document.getElementById('historyTable');
      tbody.innerHTML = '';
      const today = new Date().toISOString().split('T')[0];
      const pastMeetings = data.filter(m => m.meeting_date < today);

      pastMeetings.forEach(row => {
        const formattedDate = formatMeetingDate(row.meeting_date);
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td class="border px-3 py-2">${row.title}</td>
          <td class="border px-3 py-2">${formattedDate}</td>
          <td class="border px-3 py-2">${row.meeting_time}</td>
          <td class="border px-3 py-2">${row.venue}</td>
          <td class="border px-3 py-2">${row.organized_by}</td>
          <td class="border px-3 py-2">${row.contact_info}</td>
          <td class="border px-3 py-2">${row.meeting_type}</td>
          <td class="border px-3 py-2">${row.status}</td>
        `;
        tbody.appendChild(tr);
      });
    })
    .catch(err => console.error('Error loading history:', err));
}

// ---------- Format date as 21-Oct-2025 (Tue) ----------
function formatMeetingDate(dateStr) {
  const date = new Date(dateStr);
  const options = { day: '2-digit', month: 'short', year: 'numeric' };
  const dayName = date.toLocaleDateString('en-US', { weekday: 'short' });
  return `${date.toLocaleDateString('en-GB', options).replace(/ /g, '-') } (${dayName})`;
}


  // ---------- HANDLE EDIT BUTTON ----------
  function openEditForm(meeting){
    document.querySelector('[data-tab="add"]').click();
    const form = document.getElementById('addMeetingForm');
    form.title.value = meeting.title;
    form.meeting_date.value = meeting.start.split('T')[0];
    //form.meeting_time.value = meeting.start.split('T')[1] || '00:00:00';
    // Extract HH:MM part for <input type="time">
const timeString = meeting.start.includes('T')
  ? meeting.start.split('T')[1].substring(0, 5)
  : '00:00';
form.meeting_time.value = timeString;

	form.venue.value = meeting.venue;
    form.organized_by.value = meeting.organized_by;
    form.contact_info.value = meeting.contact_info;
    form.description.value = meeting.description;
    form.status.value = meeting.status;

    if(!form.querySelector('input[name="id"]')){
      const idInput = document.createElement('input');
      idInput.type = 'hidden';
      idInput.name = 'id';
      form.appendChild(idInput);
    }
    form.id.value = meeting.id;
  }

  // ---------- TABLE ACTIONS ----------
  document.getElementById('meetingsTable').addEventListener('click', function(e){
    const id = e.target.dataset.id;
    if(!id) return;

    // Delete Meeting
    if(e.target.classList.contains('delete-btn')){
      if(confirm('Are you sure you want to delete this meeting?')){
        fetch('../actions/delete_meeting.php', {
          method:'POST',
          headers: {'Content-Type':'application/x-www-form-urlencoded'},
          body: 'id='+id
        })
        .then(res=>res.json())
        .then(resp=>{
          if(resp.success){
            alert('✅ Meeting deleted!');
            loadTable();
            loadMeetingStats();
            loadCalendar();
          } else {
            alert('Error: '+resp.error);
          }
        });
      }
    }

    // Edit Meeting
    if(e.target.classList.contains('edit-btn')){
      const meeting = meetingsData.find(m=>m.id==id);
      if(meeting) openEditForm(meeting);
    }
  });

  // ---------- ADD / EDIT FORM ----------
const form = document.getElementById('addMeetingForm');
form.addEventListener('submit', function(e){
  e.preventDefault();
  const formData = new FormData(this);
  const url = formData.get('id') ? '../actions/update_meeting.php' : '../actions/add_meeting.php';

  fetch(url, { method:'POST', body: formData })
    .then(res => res.json())
    .then(resp => {
      if(resp.success){
        alert('✅ Meeting saved!');
        form.reset();
        const idInput = form.querySelector('input[name="id"]');
        if (idInput) form.removeChild(idInput);
        loadTable();
        loadMeetingStats();
        loadCalendar();
      } else {
        alert('❌ Error: ' + resp.error);
      }
    })
    .catch(err => console.error('Error:', err));
});

  // Auto-update meeting statuses
fetch('../actions/auto_update_status.php')
  .then(res => res.json())
  .then(data => {
    console.log('✅ Auto status update:', data.message || 'No message');
    loadMeetingStats();
    document.querySelector('[data-tab="calendar"]').click();
    setInterval(loadMeetingStats, 10000);
  })
  .catch(err => console.error('Auto update failed:', err));

  // ---------- SUMMARY CARDS ----------
  
  function loadMeetingStats(){
    fetch('../actions/get_meeting_stats.php')
      .then(res=>res.json())
      .then(data=>{
        document.getElementById('totalMeetings').textContent = data.total;
        document.getElementById('completedMeetings').textContent = data.completed;
        document.getElementById('upcomingMeetings').textContent = data.upcoming;
        document.getElementById('monthMeetings').textContent = data.month;
      })
      .catch(err => console.error('Error loading stats:', err));
  }

  // ---------- INITIAL LOAD ----------
  loadMeetingStats();
  document.querySelector('[data-tab="calendar"]').click();
  setInterval(loadMeetingStats, 10000); // auto-refresh cards every 10 sec

});
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<!-- jsPDF + autoTable -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>

<script>
document.getElementById('printPDF').addEventListener('click', () => {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF('landscape');

  // Title with month & year
  const now = new Date();
  const month = now.toLocaleString('default', { month: 'long' });
  const year = now.getFullYear();
  doc.setFontSize(16);
  doc.setTextColor(30, 58, 138);
  doc.text(`VC Engagements & Meetings Report –  ${year}`, 14, 20);

  // Get table rows from the existing HTML table
  const rows = [];
  document.querySelectorAll('#meetingsTable tr').forEach((tr, i) => {
    if (i === 0) return; // skip header if you already have one
    const cells = Array.from(tr.children).map(td => td.innerText.trim());
    // remove last element if it's actions column
    if (cells.length > 6) cells.pop();
    rows.push(cells);
  });

  // Define table header
  const headers = [['Title', 'Date', 'Time', 'Venue', 'Organized By', 'Contact Info','Meeting Type','Status','Discription']];

  // Add the table
  doc.autoTable({
    head: headers,
    body: rows,
    startY: 30,
    theme: 'grid',
    styles: { fontSize: 10, cellPadding: 4 },
    headStyles: { fillColor: [30, 58, 138], textColor: 255, halign: 'center' },
    alternateRowStyles: { fillColor: [240, 240, 240] },
  });

  // Save the PDF
  doc.save(`VC_Engagements_Report_${month}_${year}.pdf`);
});
</script>

<style>
#meetingsTable {
  width: 100%;
  border-collapse: collapse;
  font-family: 'Poppins', sans-serif;
  font-size: 13px;
  text-align: left;
}

#meetingsTable th {
  background: #1e3a8a;
  color: #fff;
  padding: 10px;
}

#meetingsTable td {
  border: 1px solid #ddd;
  padding: 8px;
}

#meetingsTable tr:nth-child(even) {
  background-color: #f3f4f6;
}

</style>
<!-- ====== DASHBOARD FOOTER ====== -->


</body>
</html>
